/* Ernesta Pozingyte
3. Realizuoti dinamines duomenu aibes operacijas minimum, maximum, predecessor ir successor,
raudonai-juodo medzio pagrindu. */                                                  

#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
typedef enum ColourType {red, black} ColourType;

struct RedBlackNode {
	int value;         // virsunes skaitine reiksme
	ColourType colour;
	RedBlackNode *parent;
	RedBlackNode *left;
	RedBlackNode *right;
};

typedef struct RedBlackNode *Tree;

// Norimo iterpti skaiciaus paieska esamame medyje
Tree Search (int X, Tree T) {
	Tree Temp = T;
	while(Temp != NULL) {
		if(Temp -> value == X)
			return NULL;        // Jei ieskomas skaicius egzistuoja tai grazina NULL
		else
			if(X < Temp -> value)
				Temp = Temp -> left;
		else
			Temp = Temp -> right;
	}
	return T;        // Jei neegzistuoja arba medis tuscias - grazina pradini medi
}

// Paprasta iterpimo f-ja binariniam medziui
Tree Insert (Tree T, RedBlackNode *node1) {     // T - rodykle
	Tree Temp = T;
	Tree Temp2 = NULL;
	while (Temp != NULL) {               // Iterpimo vietos paieska
		Temp2 = Temp;                     // Temp2 rodys i teva, kurio sunumi taps X
		if(node1->value < Temp->value)
			Temp=Temp->left;
		else
			Temp=Temp->right;
	}
	node1 -> parent = Temp2;
	if(T == NULL)                         // Jei medis tuscias
		T = node1;
	else
		if(node1->value < Temp2->value)  // O jei ne tai paziurime kur iterpti
			Temp2->left = node1;
		else
			Temp2->right = node1;
	return T;
}

// Posukis kairen pusen
Tree left_rotate(Tree T, RedBlackNode *x) {
	Tree yy;
	yy = x->right;
	x->right = yy->left;    // Pasuka kairen y'ko submedi i x'o desini submedi
	if(yy->left != NULL)
		yy->left->parent = x;
	yy->parent = x->parent;   // "Tevu" apsikeitimas
	if(x->parent == NULL)     // Paziurime ar ne saknyje esame
		T = yy;
	else
		if(x == (x->parent)->left)
			x->parent->left = yy;
		else
			x->parent->right = yy;
	yy->left = x;             // Prikabiname x kaireje
	x->parent = yy;
	return T;
}

// Posukis desinen pusen simetriskas posukiui i kaire - keiciasi right ir left
Tree right_rotate(Tree T, RedBlackNode *x) {
	Tree yy;
	yy = x->left;
	x->left = yy->right;
	if(yy->right != NULL)
		yy->right->parent = x;
	yy->parent = x->parent;
	if(x->parent == NULL)
		T = yy;
	else
		if(x == (x->parent)->right)
			x->parent->right = yy;
		else
			x->parent->left = yy;
	yy->right = x;
	x->parent = yy;
	return T;
}
//#######################################################
// Iterpimas i Raudona - Juoda medi
Tree rb_insert( Tree T, RedBlackNode *node ) {
	Tree tmp;
	T = Insert(T, node);        // T - turimas paprastas medis
	node -> colour = red;
	while ((node != T) && (node -> parent -> colour == red)) {
		if(node->parent == node->parent->parent->left) {
			tmp = node->parent->parent->right;
			if((tmp!=NULL) && (tmp->colour == red)) {
				node->parent->colour = black;      // 1 atvejis
				tmp->colour = black;
				node->parent->parent->colour = red;
				node = node->parent->parent;
			}
			else {
				if(node == node->parent->right) {
					node = node->parent;             // 2 atvejis
					T = left_rotate(T,node);
					}
				node->parent->colour = black;      // 3 atvejis
				node->parent->parent->colour = red;
				T = right_rotate( T, node->parent->parent );
			}
		}    // simetriskai tikriname kita saka kurioje vel trys atvejai bus
		else 
			if(node->parent == node->parent->parent->right) {
				tmp = node->parent->parent->left;
				if((tmp != NULL) && (tmp->colour == red)) {
					node->parent->colour = black;
					tmp->colour = black;
					node->parent->parent->colour = red;
					node = node->parent->parent;
				}
				else {
					if(node == node->parent->left) {
						node = node->parent;
						T =  right_rotate(T,node);
					}
					node->parent->colour = black;
					node->parent->parent->colour = red;
					T = left_rotate( T, node->parent->parent );
				}
			}
	}
	T->colour = black;            //saknis turi buti juoda
	return T;
}

// Medzio apejimas InOrder
void print(Tree T) {
	if(T != NULL) {
		print(T->left);
		cout << T->value << "\n";
		print(T->right);
	}
}
//----------------------------
 /*
Tree Minimum (Tree T){
   /*if (T != NULL) {
      print(T->left);
   }*/
   //RedBlackNode *min;
   //int min;
   /*Tree Temp4 = T;
   //if (Temp4 == NULL)
   while(Temp4 -> left != NULL) {
      cout << (Temp4 -> value); //Temp4 -> value;
      Temp4 -> left;     */ /*
   }     */
   /**//*cout << " min " ;

    //cin >> min;
   //return min;
}*/

Tree Minimum (Tree T) {
   int min;
   while (T != NULL) {
      min = T -> value;
      T = T -> left;
   }
   cout << "Operacija Minimum : " << min << endl;
}

Tree Maximum (Tree T) {
   //int max;
   RedBlackNode *max;
   //int *max;
   while (T != NULL) {
      max = T -> value;
      T = T -> right;
   }
   //cout << "Operacija Maximum : " << max << endl;
   return *max;
}

Tree Predecessor (Tree T) {
   int pr;
   while (T != NULL) {
      T = T -> left;
      //Maximum (T);
   }
   cout << "Operacija Predecessor : " << pr << endl;
}

/*
/*Tree Predecessor (Tree T) {
   int pr;
   while (T != NULL) {
      T = T -> left;
      //if ((T -> left -> value != NULL) && (T -> right -> value != NULL) ) {
      if ((T -> left -> value != NULL) && (T -> right -> value != NULL) ) {
         cout << "hello! " << endl;
      }
      //Maximum (T);
   }
   cout << "Operacija Predecessor : " << pr << endl;
}*/

*/

//___________________________________________________________________________
//---------------------------------------------------------------------------
main() {
   // Medzio sudarymas
	Tree medis = NULL;
	int kiek, X, i;       /**/char a;
	cout << "Keliu skaitmenu medi sukurti?" << endl;
	cin >> kiek;

   char *infile = "data.txt";
   ifstream inf(infile);

	for(i = 0; i < kiek; i++) {
		inf >> X;
		if ((Search(X, medis) != NULL) || (medis == NULL)) {      // Jei ieskomas sk. neegzist. arba medis tuscias
			Tree Temp3 = new(RedBlackNode);          // Naujo iraso sukurimas
			Temp3 -> value = X;                      // Temp3 - rodykle, X - sk. is data.txt, value - node reiksme
			medis = rb_insert(medis, Temp3);         // Iterpiamas sukurtas irasas
		}
	}
   inf.close();

	if(medis != NULL) {
		cout << "Medis, apeitas infiksine tvarka :\n";
		print (medis);
      cout << "______________________" << endl;
      Minimum(medis);
      //Maximum(medis);
      print << "Max : " << Maximum(medis) << endl;

      Predecessor(medis);
      //Successor(medis);

      /**/cout<<"..."; cin>>a;
	}

	else cout << "Medis tuscias!\n";

	cout << "Baigta!\n";
	//int getchar();
	//int getchar();
}

